/****** Object:  Trigger [TRG_RC_CLI_FIDELI_VD]    Script Date: 04/07/2014 11:46:00 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_RC_CLI_FIDELI_VD]'))
DROP TRIGGER [dbo].[TRG_RC_CLI_FIDELI_VD]
GO
GO
GO

CREATE TRIGGER [dbo].[TRG_RC_CLI_FIDELI_VD] ON [dbo].[PDV_VD] FOR INSERT, UPDATE, DELETE AS
BEGIN 

	DECLARE @FLAG_DELETE TINYINT
	DECLARE @FLAG_INCLUI TINYINT
	
	SET @FLAG_DELETE = 0
	SET @FLAG_INCLUI = 0

	-----------------------------------------------------------------------------------
	--Verificando se houve alterao do cliente 
	-----------------------------------------------------------------------------------
	IF EXISTS (SELECT i.CD_EMP 
			   FROM INSERTED i INNER JOIN DELETED d ON
					i.CD_EMP		= d.CD_EMP
					AND i.CD_FILIAL = d.CD_FILIAL
					AND i.CD_VD		= d.CD_VD)
		BEGIN 
			IF UPDATE(CD_CLI)
				BEGIN
					SET @FLAG_DELETE = 1
					SET @FLAG_INCLUI = 1
				END
		END
	ELSE 
		BEGIN 
			--Verificando se a venda est sendo includa
			IF EXISTS (SELECT i.CD_EMP 
					   FROM INSERTED i INNER JOIN RC_CLI cli ON
							i.CD_EMP	 = cli.CD_EMP
							AND i.CD_CLI = cli.CD_CLI
					   WHERE cli.FLAG_CLI_FIDEL = 1)
				BEGIN
					SET @FLAG_INCLUI = 1
				END
			--Venda sendo deletada
			ELSE
				BEGIN
					SET @FLAG_DELETE = 1
				END
		END

	-----------------------------------------------------------------------------------
	--Reduzindo a quantidade de vendas fidelidade na data 
	-----------------------------------------------------------------------------------
	IF @FLAG_DELETE = 1 
		BEGIN
			UPDATE fv SET 
				QT_VD = fv.QT_VD - 1
			FROM DELETED d INNER JOIN RC_CLI_FIDELI_VD fv ON
				d.CD_EMP		= fv.CD_EMP
				AND d.CD_CLI	= fv.CD_CLI
				AND d.DT_VD		= fv.DT_VD
			where  d.CD_CLI<> 1
		END		

	-----------------------------------------------------------------------------------
	--Aumentando a quantidade de vendas fidelidade na data 
	-----------------------------------------------------------------------------------
	IF @FLAG_INCLUI = 1
		BEGIN
			IF EXISTS ( SELECT i.CD_EMP 
						FROM INSERTED i INNER JOIN RC_CLI_FIDELI_VD fv ON
							i.CD_EMP		= fv.CD_EMP
							AND i.CD_CLI	= fv.CD_CLI
							AND i.DT_VD		= fv.DT_VD)
				BEGIN
					UPDATE fv SET 
						QT_VD = fv.QT_VD + 1
					FROM INSERTED i INNER JOIN RC_CLI_FIDELI_VD fv ON
						i.CD_EMP		= fv.CD_EMP
						AND i.CD_CLI	= fv.CD_CLI
						AND i.DT_VD		= fv.DT_VD
						where  i.CD_CLI<> 1
				END
			ELSE
				BEGIN
					INSERT INTO RC_CLI_FIDELI_VD (CD_EMP, CD_CLI, DT_VD, QT_VD)
						SELECT  i.CD_EMP, 
								i.CD_CLI, 
								i.DT_VD, 
								1 AS QT_VD
						FROM INSERTED i
						where not isnull(i.cd_cli,0) > 1
				END		
		END
END
